﻿//menu定义
var MENU_ADD_FIRST_DESC = 1;
var MENU_ADD_STREAM = 2;
var MENU_STREAM = 3;

var menuIdArray = ["modifyTable", "addFirstDesc", "addStream","streamMenu", "", "descMenu"];
var MENU_NUM = 6;
var newStreamId;

function modifyTable()
{
	actionType = SET;
	operation = OPER_TABLE;	
	displayParam();
	$("#table").css("display", "");
	$("#stream").css("display", "none");
	if(language == ENGLISH)
	{
		$("#editHeader").html("Table Info");
	}
	else
	{
		$("#editHeader").html("表信息");
	}
	$("#editInfo").modal();
}

function addStream()
{
	actionType = ADD;
	operation = OPER_STREAM;	
	editStream();
}

function modifyStream()
{
	actionType = SET;
	operation = OPER_STREAM;	
	displayParam();
	editStream();
}

function editStream()
{
	$("#table").css("display", "none");
	$("#stream").css("display", "");
	if(language == ENGLISH)
	{
		$("#editHeader").html("Stream Info");
	}
	else
	{
		$("#editHeader").html("流信息");
	}
	$("#editInfo").modal();
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formIPQAM?type=" + psiType + "&cmd=" + GET + "&language=" + language + "&id=" + id + "&operation=" + operation + "&index=" + nodeIndex + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				if(operation == OPER_TABLE)
				{
					if(psiType == BAT)
					{
						$("#bouquetId").val(data[0]);
					}
					else
					{
						$("#networkId").val(data[0]);	
					}									
					$("#versionNumber").val(data[1]);
				}
				else if(operation = OPER_STREAM)
				{
					$("#streamId").val(data[0]);
					$("#originalNetId").val(data[1]);	
				}
				refreshFlag = true;	
			}
		}
	}
	xmlHttp.send(null);	
}

function editPageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + psiType + "&cmd=" + actionType + "&language=" + language + "&id=" + id + "&operation=" + operation + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			$.modal.close();
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(actionType == ADD)
				{
					if(language == ENGLISH)
					{
						alert("Add Successfully!");
					}
					else
					{
						alert("添加成功！");
					}
					self.location.reload(true);
				}
				else if(actionType == SET)
				{
					if(language == ENGLISH)
					{
						alert("Set Successfully!");
					}
					else
					{
						alert("设置成功！");
					}
					if(operation == OPER_TABLE)
					{
						var newPsIidString = [idString[0], idString[1], idString[2], idString[3], newStreamId, idString[5]];
						var newUrl = replaceParamVal(self.location.href, "psiId", newPsIidString.join("_"));
						window.location.replace(newUrl);
					}
					else
					{
						self.location.reload(true);
					}
				}
			}
			else
			{
				alert(returnError[language][response]);
				self.location.reload(true);
			}
		}
	}
	xmlHttp.send(data);
}

function replaceParamVal(oldUrl, paramName, replaceWith)
{
    var re = eval('/(' + paramName + '=)([^&]*)/gi');
    var nUrl = oldUrl.replace(re, paramName + '=' + replaceWith);
    return nUrl;
}

function paramCheck()
{	
	var returnFlag;
	
	if(operation == OPER_TABLE)
	{
		if(psiType == BAT)
		{
			returnFlag = ValidateParam($("#bouquetId"), "INT_DEC",  0, 65535, "<Bouquet_Id>", "<业务群ID>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}
		else
		{
			returnFlag = ValidateParam($("#networkId"), "INT_DEC",  0, 65535, "<Network ID>", "<网络ID>", language);
			if(returnFlag == false)
			{
				return false;
			}
		}		
		returnFlag = ValidateParam($("#versionNumber"), "INT_DEC",  0, 31, "<Version Num>", "<版本号>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	else if(operation == OPER_STREAM)
	{
		returnFlag = ValidateParam($("#streamId"), "INT_DEC",  0, 65535, "<Stream ID>", "<流ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#originalNetId"), "INT_DEC",  0, 65535, "<Original Network ID>", "<原始网络ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

function generateData()
{
	var data;
	if(operation == OPER_TABLE)
	{
		if(psiType == BAT)
		{
			data = $("#bouquetId").val() + FIRST_DELIMITER + $("#versionNumber").val();
			newStreamId = parseInt($("#bouquetId").val(), 10);
		}
		else
		{
			data = $("#networkId").val() + FIRST_DELIMITER + $("#versionNumber").val();
			newStreamId = parseInt($("#networkId").val(), 10);
		}	
	}
	else if(operation == OPER_STREAM)
	{
		if(actionType == ADD)
		{
			data = $("#streamId").val() + FIRST_DELIMITER + $("#originalNetId").val();
		}
		else if(actionType == SET)
		{
			data = nodeIndex + FIRST_DELIMITER + $("#streamId").val() + FIRST_DELIMITER + $("#originalNetId").val();
		}		
	}	
	return data;
}

function deleteStream()
{	
	var confirmPrompt;
	operation = OPER_STREAM;
	
	if(language == ENGLISH)
	{
		confirmPrompt = "Are you sure to delete the stream?";
	}
	else
	{
		confirmPrompt = "确定要删除当前流吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		deleteApply();
	}	
}